#include <sys/types.h>

unsigned long mem_usage_stats[32];
unsigned long mem_alloc[32], mem_alloc_bytes[32];
unsigned long mem_dealloc[32], mem_dealloc_bytes[32];

void init_mem_stats() {
  int i;

  for(i=0;i<32;i++) {
    mem_usage_stats[i] = 0;
    mem_alloc[i] = 0; mem_alloc_bytes[i] = 0;
    mem_dealloc[i] = 0; mem_dealloc_bytes[i] = 0;
  }
}
void *my_malloc(size_t size, int bucket) {
  void *my_pointer, *top;

  my_pointer = (void *)malloc(size+4);
  if (my_pointer) {
    mem_usage_stats[bucket]+=size;
    mem_alloc[bucket]++;
    mem_alloc_bytes[bucket]+=size;
  }
  memcpy(my_pointer, &size, sizeof(size));
  my_pointer+=4;
  //printf("Allocated 0x%x %d bytes to bucket %d\n", my_pointer, size, bucket);
  return my_pointer;
}


void my_free(void *ptr, int bucket) {
  size_t size;

  ptr-=4;
  memcpy(&size, ptr, sizeof(size));
  //printf("Freed 0x%x %d bytes from bucket %d\n", ptr, size, bucket);
  free(ptr);
  mem_usage_stats[bucket]-=size;
  mem_dealloc[bucket]++;
  mem_dealloc_bytes[bucket]+=size;
}
