# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the logout data for a VCS system.
"""

from qt import *

from LogoutForm import vcsLogoutForm
from Config import ConfigVcsAuthSystems

class vcsLogoutDialog(vcsLogoutForm):
    """
    Class implementing a dialog to enter the logout data for a VCS system.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        vcsLogoutForm.__init__(self, parent, None, 1)
        
        self.validator = QIntValidator(self)
        self.portEdit.setValidator(self.validator)
        
        vcsSystems = QStringList()
        for vcssys in ConfigVcsAuthSystems:
            vcsSystems.append(vcssys)
        self.vcsComboBox.insertStringList(vcsSystems)
        self.handleVcsSelected(vcsSystems[0])
        
        dummy = self.trUtf8('dummy')
        
    def handleVcsSelected(self, vcs):
        """
        Private slot used to populate the protocol combobox.
        
        @param vcs the selected version control system (QString)
        """
        self.protocolComboBox.clear()
        if vcs.compare(ConfigVcsAuthSystems[0]) == 0:        # CVS
            import cvsPackage.Config
            self.protocolComboBox.insertStringList(cvsPackage.Config.ConfigCvsProtocols)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 4 strings (vcs system, username, 
            remote hostname and repository).
        """
        return (unicode(self.vcsComboBox.currentText()),
            unicode(self.protocolComboBox.currentText()),
            unicode(self.usernameEdit.text()),
            unicode(self.hostEdit.text()),
            unicode(self.portEdit.text()),
            unicode(self.repositoryEdit.text())
        )
