
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __DARKSTAT_H
#define __DARKSTAT_H

#define COPYRIGHT "Copyright (C) 2001-2003, Emil Mikulic."
#define HOMEPAGE "http://purl.org/net/darkstat"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* if we're doing a debug compile, turn off inlining */
#ifndef NDEBUG
# ifdef inline
#  undef inline
# endif
# define inline
#endif

#include "gettext.h"
#define _ gettext

#ifdef __GNUC__
# define unused __attribute__ ((__unused__))
#else
# define unused
#endif

/* so I grew up on Turbo Pascal */
typedef unsigned char byte;	/*  8 bits */
typedef unsigned short word;	/* 16 bits */
typedef unsigned int dword;	/* 32 bits */

#define DEFAULT_WEBPORT 666
extern int webport, webip;
#define HOST_REPORT_LIMIT 25
#define PORT_REPORT_LIMIT 50

#define DB_FILE_NAME "darkstat.db"
#define ERRDB_FILE_NAME "darkstat.err"
#define DAYLOG_FILE_NAME "darkstat.daylog"
#define SPYLOG_FILE_NAME "darkstat.spylog"
#define PID_FILE_NAME "darkstat.pid"
extern char *errdb_file, *db_file, *daylog_file, *pid_file;
extern const char *fprefix;

#define PCAP_TIMEOUT 1000 /* ms */
#define EXIT_SUCCESS 0
#define EXIT_FAIL 1
#define SAVE_TIME 60*5 /* secs inbetween DB dumps */
#define MSEC 1000  /* for usleep() */
#define SOCKET int /* WinSock? err... */

#ifndef max
#define max(a,b) ( ((a)>(b))?(a):(b) )
#endif

#ifndef min
#define min(a,b) ( ((a)<(b))?(a):(b) )
#endif

typedef enum {MAIN, IN, OUT, TOTAL} sort_type;

extern int verbose, shutting_down, promisc;
extern int up_dns, up_www, up_spy, up_acct;
extern char *acctdev, *acctexpr;

char *build_str(const char *format, ...);
void freakout(const char *err);
void print_addr(const dword ip);
void save_db(const char *filename);



/* packet stuff */
dword get_local_ip(char *inter);
void interpret_linktype(int linktype, byte *pdata,
        byte **ptr, word *pkt_type);

#define ETH_PKT_TYPE_IP 0x0800
#define eth_pkt_type(pkt) ntohs( ((word*)pkt)[6] )
#define eth_pkt_strip(pkt) (pkt+14)

#define IP_PROTO_ICMP 1 /* Internet Control Message Protocol */
#define IP_PROTO_TCP 6  /* Transmission Control Protocol */
#define IP_PROTO_UDP 17 /* User Datagram Protocol */
#define ip_pkt_len(pkt) ntohs( ((word*)pkt)[1] )
#define ip_pkt_proto(pkt) pkt[9]
#define ip_pkt_srcip(pkt) ntohl( ((dword*)(pkt+12))[0] )
#define ip_pkt_destip(pkt) ntohl( ((dword*)(pkt+16))[0] )
#define ip_pkt_strip(pkt) (pkt+20)

#define tcp_pkt_srcport(pkt) ntohs( ((word*)pkt)[0] )
#define tcp_pkt_destport(pkt) ntohs( ((word*)pkt)[1] )
/*#define tcp_pkt_seq(pkt) ntohl( ((dword *)pkt)[1] )
#define tcp_pkt_ack(pkt) ntohl( ((dword *)pkt)[2] )*/
#define tcp_flags(pkt) ((byte) (pkt[13] & 0x3F))

#define TCP_URG (1<<5)
#define TCP_ACK (1<<4)
#define TCP_PSH (1<<3)
#define TCP_RST (1<<2)
#define TCP_SYN (1<<1)
#define TCP_FIN (1<<0)

#endif

