(*
 * bibtex2html - A BibTeX to HTML translator
 * Copyright (C) 1997-2000 Jean-Christophe Fillitre and Claude March
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the GNU General Public License version 2 for more details
 * (enclosed in the file GPL).
 *)

(*i $Id: latex_accents.mll,v 1.7 2003/10/03 15:37:30 marche Exp $ i*)

{

  let string_buf = Buffer.create 79
                     
  let add_string s = Buffer.add_string string_buf s

  let add lexbuf = Buffer.add_string string_buf (Lexing.lexeme lexbuf)

  let produce_regexp = ref false

}

let space = [ '\t']

rule next_char = parse
    '\\'                          { control lexbuf }
  | '{'                           { next_char lexbuf }
  | '}'                           { next_char lexbuf }
  | _                             { add lexbuf ; next_char lexbuf }
  | eof                           { () }


(* called when we have seen  "\\"  *)

and control = parse
  '"'                { quote_char lexbuf }
| '\''               { right_accent lexbuf }
| '`'                { left_accent lexbuf }
| '^'                { hat lexbuf }
| "c{c}"             { add_string "" ; next_char lexbuf }
| 'v'                
    { add_string (if !produce_regexp then "\\\\v" else "\\v"); 
      next_char lexbuf }
| ("~n"|"~{n}")      { add_string ""; next_char lexbuf  }
|  _                 { add_string "\\" ; add lexbuf ; next_char lexbuf  }
| eof                { add_string "\\" }

(* called when we have seen  "\\\""  *)
and quote_char = parse
  ('a'|"{a}")                   { add_string "" ; next_char lexbuf }
| ('o'|"{o}")                   { add_string "" ; next_char lexbuf }
| ('u'|"{u}")                   { add_string "" ; next_char lexbuf }
| ('e'|"{e}")                   { add_string "" ; next_char lexbuf }
| ('A'|"{A}")                   { add_string "" ; next_char lexbuf }
| ('O'|"{O}")                   { add_string "" ; next_char lexbuf }
| ('U'|"{U}")                   { add_string "" ; next_char lexbuf }
| ('E'|"{E}")                   { add_string "" ; next_char lexbuf }
| ("\\i" space+|"{\\i}")        { add_string "" ; next_char lexbuf }
| ('I'|"\\I" space+|"{\\I}")    { add_string "" ; next_char lexbuf }
| _                             { add_string "\\\"" ; add lexbuf }
| eof                           { add_string "\\\"" }

(* called when we have seen  "\\'"  *)
and right_accent = parse
| ('a'|"{a}")   { add_string "" ; next_char lexbuf }
| ('o'|"{o}")   { add_string "" ; next_char lexbuf }
| ('u'|"{u}")   { add_string "" ; next_char lexbuf }
| ('e'|"{e}")   { add_string "" ; next_char lexbuf }
| ('A'|"{A}")   { add_string "" ; next_char lexbuf }
| ('O'|"{O}")   { add_string "" ; next_char lexbuf }
| ('U'|"{U}")   { add_string "" ; next_char lexbuf }
| ('E'|"{E}")   { add_string "" ; next_char lexbuf }
| ('i'|"\\i" space+|"{\\i}") { add_string "" ; next_char lexbuf }
| ('I'|"\\I" space+|"{\\I}") { add_string "" ; next_char lexbuf }
| _             { add_string "\\'" ; add lexbuf ; next_char lexbuf }
| eof           { add_string "\\'" }

(* called when we have seen "\\`"  *)
and left_accent = parse
  ('a'|"{a}")   { add_string "" ; next_char lexbuf }
| ('o'|"{o}")   { add_string "" ; next_char lexbuf }
| ('u'|"{u}")   { add_string "" ; next_char lexbuf }
| ('e'|"{e}")   { add_string "" ; next_char lexbuf }
| ('A'|"{A}")   { add_string "" ; next_char lexbuf }
| ('O'|"{O}")   { add_string "" ; next_char lexbuf }
| ('U'|"{U}")   { add_string "" ; next_char lexbuf }
| ('E'|"{E}")   { add_string "" ; next_char lexbuf }
| ('i'|"\\i" space+ |"{\\i}") { add_string "" ; next_char lexbuf }
| ('I'|"\\I" space+ |"{\\I}") { add_string "" ; next_char lexbuf }
| _             { add_string "\\`" ; add lexbuf ; next_char lexbuf }
| eof           { add_string "\\`" }

and hat = parse
  ('a'|"{a}")   { add_string "" ; next_char lexbuf }
| ('o'|"{o}")   { add_string "" ; next_char lexbuf }
| ('u'|"{u}")   { add_string "" ; next_char lexbuf }
| ('e'|"{e}")   { add_string "" ; next_char lexbuf }
| ('A'|"{A}")   { add_string "" ; next_char lexbuf }
| ('O'|"{O}")   { add_string "" ; next_char lexbuf }
| ('U'|"{U}")   { add_string "" ; next_char lexbuf }
| ('E'|"{E}")   { add_string "" ; next_char lexbuf }
| ('i'|"\\i" space+ |"{\\i}") { add_string "" ; next_char lexbuf }
| ('I'|"\\I" space+ |"{\\I}") { add_string "" ; next_char lexbuf }
| _             { add_string "\\^" ; add lexbuf ; next_char lexbuf }
|  eof          { add_string "\\^" }

{

let normalize to_regexp s = 
  Buffer.clear string_buf;
  produce_regexp := to_regexp;
  next_char (Lexing.from_string s);
  Buffer.contents string_buf
;;

}
