##############################################################################
#
# Copyright (c) 2005-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import ir
from mx.DateTime import now
from osv.osv import osv_pools
import netsvc

bill_form = """<?xml version="1.0" ?>
<form string="Billing wizard">
	<field name="order_num"/>
	<field name="total"/>
	<field name="method"/>
</form>"""

bill_fields = {
	'order_num' : {'string':'Number of orders', 'type': 'integer', 'readonly': 'True'},
	'total' : {'string':'Total of the bills', 'type': 'float', 'readonly': 'True'},
	'method' : {'string':'Method', 'type':'selection', 'selection':[('draft','Draft Order'),('confirm','Confirm Order')], 'default':lambda *a:'draft', 'required':True}
}

ack_form = """<?xml version="1.0" ?>
<form string="Billing wizard">
	<separator string="The orders were successfully generated" />
</form>"""

ack_fields = {}

def _compute_orders(self, cr, uid, data, context):
	tasks = osv_pools.get('project.task').browse(cr, uid, data['ids'])
	projects = {}
	tot = 0.0
	for task in tasks:
		project = task.project_id
		projects[project.id] = projects.get(project.id, []) + [task.id]
		if not task.order_id and task.billable:
			if project.mode == 'project':
				tot += project.tariff
			elif project.mode == 'effective':
				tot += project.tariff * task.effective_hours
			elif project.mode == 'hour':
				tot += project.tariff * task.planned_hours
	res = {'order_num': len(projects), 'total': tot}
	return res

def _do_orders(self, cr, uid, data, context):
	tasks = osv_pools.get('project.task').browse(cr, uid, data['ids'])
	orderline = osv_pools.get('sale.order.line')
	customers = {}
#TODO: we need to take into account the task.partner_id in addition to project_id.partner_id
	for task in filter(lambda t: t.billable and not t.order_id, tasks):
		if not task.project_id.id in customers:
			partner = task.partner_id or task.project_id.partner_id
			adr = osv_pools.get('res.partner').address_get(cr, uid, [partner.id], ['default','invoice','shipping'])

			oid = osv_pools.get('sale.order').create(cr, uid, {
				'note': 'Project Order %s' % task.project_id.name,
				'shop_id': task.project_id.shop_id.id,
				'state': 'draft',
				'partner_id': partner.id,
				'partner_order_id': adr['default'],
				'partner_invoice_id': adr['invoice'],
				'partner_shipping_id': adr['shipping'],
				'order_policy': 'manual',
				'pricelist_id': task.project_id.pricelist_id.id,
				'project_id': task.project_id.category_id.id
			})
			customers[task.project_id.id] = oid
		else:
			oid = customers[task.project_id.id]

		if task.project_id.mode == 'project':
			qty = 1
		elif task.project_id.mode == 'effective':
			qty = task.effective_hours
		elif task.project_id.mode == 'hour':
			qty = task.planned_hours

		orderline.create(cr, uid, {
			'order_id': oid,
			'name': task.name,
			'price_unit': task.project_id.tariff,
			'product_uom_qty': qty,
			'product_uom': task.product_uom.id,
			'product_uos': task.product_uom.id,
			'product_uos_qty': qty,
			'tax_id': [(6,0, [t.id for t in task.project_id.tax_ids])]

		})
		if task.product_id:
			if not task.product_uom.id:
				raise 'You must put a unit of measure for this task !'

			price = osv_pools.get('product.pricelist').price_get(cr, uid, [task.project_id.pricelist_id.id], task.product_id.id, task.product_qty or 1.0)[task.project_id.pricelist_id.id]
			orderline.create(cr, uid, {
				'order_id': oid,
				'name': task.product_id.name,
				'product_id': task.product_id.id,
				'product_uom': task.product_uom.id,
				'product_uos': task.product_uom.id,
				'price_unit': price,
				'product_uom_qty': task.product_qty,
				'product_uos_qty': task.product_qty,
				'tax_id': [(6,0, [t.id for t in task.product_id.taxes_id])]
			})
		osv_pools.get('project.task').write(cr, uid, [task.id], {'order_id':oid})
	
	if data['form']['method']=='confirm':
		wf_service = netsvc.LocalService('workflow')
		for oid in customers:
			wf_service.trg_validate(uid, 'order.sale', oid, 'order_confirm', cr)
	return {}

class wiz_bill(wizard.interface):
	states = {
		'init':{
			'actions': [_compute_orders],
			'result': {'type':'form', 'arch':bill_form, 'fields':bill_fields, 'state':[('end', 'Cancel'), ('bill', 'Ok')] },
		},
		'bill':{
			'actions': [_do_orders],
			'result': {'type':'form', 'arch':ack_form, 'fields':ack_fields, 'state':[('end', 'Done')] },
		},
	}
wiz_bill('project.wiz_bill')

# vim:noexpandtab:tw=0
