/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.db.DBColumn;
import adql.db.SearchColumnList;
import adql.db.exception.UnresolvedJoinException;
import adql.query.ClauseConstraints;
import adql.query.IdentifierField;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.from.InnerJoin;
import adql.query.operand.ADQLColumn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SQLServer_InnerJoin
extends InnerJoin {
    public SQLServer_InnerJoin(FromContent left, FromContent right) {
        super(left, right);
    }

    public SQLServer_InnerJoin(FromContent left, FromContent right, ClauseConstraints condition) {
        super(left, right, condition);
    }

    public SQLServer_InnerJoin(FromContent left, FromContent right, Collection<ADQLColumn> lstColumns) {
        super(left, right, lstColumns);
    }

    public SQLServer_InnerJoin(InnerJoin toCopy) throws Exception {
        super(toCopy);
    }

    @Override
    public SearchColumnList getDBColumns() throws UnresolvedJoinException {
        return SQLServer_InnerJoin.getDBColumns(this);
    }

    public static SearchColumnList getDBColumns(ADQLJoin join) throws UnresolvedJoinException {
        try {
            SearchColumnList list = new SearchColumnList();
            SearchColumnList leftList = join.getLeftTable().getDBColumns();
            SearchColumnList rightList = join.getRightTable().getDBColumns();
            HashMap<String, DBColumn> mapDuplicated = new HashMap<String, DBColumn>();
            if (join.isNatural()) {
                for (DBColumn leftCol : leftList) {
                    DBColumn rightCol = SQLServer_InnerJoin.findAtMostOneColumn(leftCol.getADQLName(), (byte)0, rightList, false);
                    if (rightCol == null) continue;
                    SQLServer_InnerJoin.findExactlyOneColumn(leftCol.getADQLName(), (byte)0, leftList, true);
                    mapDuplicated.put(leftCol.getADQLName().toLowerCase(), leftCol);
                }
            } else if (join.hasJoinedColumns()) {
                Iterator<ADQLColumn> itCols = join.getJoinedColumns();
                while (itCols.hasNext()) {
                    ADQLColumn usingCol = itCols.next();
                    DBColumn leftCol = SQLServer_InnerJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), leftList, true);
                    SQLServer_InnerJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), rightList, false);
                    mapDuplicated.put(usingCol.isCaseSensitive(IdentifierField.COLUMN) ? "\"" + usingCol.getColumnName() + "\"" : usingCol.getColumnName().toLowerCase(), leftCol);
                }
            } else {
                list.addAll(leftList);
                list.addAll(rightList);
                return list;
            }
            SQLServer_InnerJoin.addAllExcept2(leftList, list, mapDuplicated);
            SQLServer_InnerJoin.addAllExcept2(rightList, list, mapDuplicated);
            list.addAll(0, mapDuplicated.values());
            return list;
        }
        catch (UnresolvedJoinException uje) {
            uje.setPosition(join.getPosition());
            throw uje;
        }
    }

    public static final void addAllExcept2(SearchColumnList itemsToAdd, SearchColumnList target, Map<String, DBColumn> exception) {
        for (DBColumn col : itemsToAdd) {
            if (exception.containsKey(col.getADQLName().toLowerCase()) || exception.containsKey("\"" + col.getADQLName() + "\"")) continue;
            target.add(col);
        }
    }
}

