/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Evaluate the moment-generating function (MGF) of a uniform distribution.
*
* @module @stdlib/stats/base/dists/uniform/mgf
*
* @example
* var mgf = require( '@stdlib/stats/base/dists/uniform/mgf' );
*
* var y = mgf( 2.0, 0.0, 4.0 );
* // returns ~372.495
*
* y = mgf( -0.2, 0.0, 4.0 );
* // returns ~0.688
*
* y = mgf( 2.0, 0.0, 1.0 );
* // returns ~3.195
*
* var mymgf = mgf.factory( 6.0, 7.0 );
* y = mymgf( 0.1 );
* // returns ~1.916
*
* y = mymgf( 1.1 );
* // returns ~1339.321
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var mgf = require( './mgf.js' );
var factory = require( './factory.js' );


// MAIN //

setReadOnly( mgf, 'factory', factory );


// EXPORTS //

module.exports = mgf;
