---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Content-Security-Policy violations

## Description

A `Content-Security-Policy` (CSP) was identified on the target site that is reporting violations when
attempting to load the page in a browser. This may cause disruption to your users when attempting to visit the page.

## Remediation

Review the violations to determine if any action is necessary.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.10 | true | 16 | Passive | Info |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Content_Security_Policy_Cheat_Sheet.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP)
- [Content Security Policy Level 3](https://www.w3.org/TR/CSP3/)
- [CSP Evaluator](https://csp-evaluator.withgoogle.com/)
