/* -*- Mode: C++; tab-width: 4 -*- */
/* vi: set ts=4 sw=4 noexpandtab: */

/*
 * Copyright (C) 2010 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef DIAGNOSTICS__EXTENSIONS__STACKTRACE__FRAME_VISITOR__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__STACKTRACE__FRAME_VISITOR__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/extensions/stacktrace/namespace.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;
namespace Traceback {

struct FrameVisitor {
  virtual ~FrameVisitor();

  // Called by Walk for each stack frame.  Unwinding continues while
  // this functions returns true.  ORIGINAL is the original address in
  // the running executable.  EXECUTABLE is the name of the DSO (0 for
  // the main program).  RELATIVE is the relative address in the
  // executable, derived from ORIGINAL; 0 on failure.
  virtual bool
  Frame(void *original, const char *executable, void *relative) = 0;

  // Walk the stack, calling Frame.
  void Walk();

  // Invokes Frame after resolving the address.  For internal use
  // only.
  bool frame(void *original);
};

// Visitor to map relative addresses to source file information.
// This class is not thread-safe because it spawns helper programs
// internally.
struct SourceVisitor {
  virtual ~SourceVisitor();

  // Invoked with the resolved addresses.  Calls Frame with all the
  // corresponding stack frames.  For a single address, multiple
  // frames may be available due to inlining.  Returns true if at
  // least one frame was found.
  bool WalkSource(const char *dso, void *reltaive);

  // Called by WalkSource.  FUNCTION is the name of the function, FILE
  // is the name of the source file, and LINE is the line number in
  // the source file.
  virtual void
  Frame(const char *function, const char *file, unsigned line) = 0;
};

} // Enyo::Traceback
STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

